<?php
    /*
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    
    $parametri = array("tabella"=>"geecD_templateCartelle", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>array("nome"=>$cerca),"ajax"=>false);
      
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"impostazioni.php");
?>
<h4 class="mb-4 title">Cartelle utenti</h4>
<ul class="nav nav-pills" id="..." role="tablist">
    <li class="nav-item" role="presentation">
        <a class="nav-link <?= ($status!=121) ? "active" : "" ?>" data-toggle="pill" href="#impostazioni" role="tab" aria-controls="pills-home" aria-selected="true">Impostazioni</a>
    </li>
    <li class="nav-item" role="presentation">
        <a class="nav-link <?= (isset($_GET["status"]) && $_GET["status"]==121) ? "active" : "" ?>" data-toggle="pill" href="#elencoTemplate" role="tab" aria-controls="pills-home" aria-selected="true">Elenco template</a>
    </li>
    <li class="nav-item" role="presentation">
        <a class="nav-link" data-toggle="pill" href="#operazioniMassive" role="tab" aria-controls="pills-home" aria-selected="true">Operazioni massive</a>
    </li>
</ul>
<div class="tab-content">
    <div id="impostazioni" class="tab-pane fade show px-0 pb-0 shadow-none <?= ($status!=121) ? "active" : "" ?>" role="tabpanel">
        <form name="formAggiornamentoImpostazioniTemplateCartelle" action="../controller/controllerImpostazioni.php" method="post">
            <input type="text" class="d-none" name="operazione" value="aggiornaImpostazioniTemplateCartelle">

            <div class="row mt-5">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="select1" class="d-block">Crea cartella radice quando si crea un nuovo utente</label>
                        <input type="checkbox" name="creaCartellaRadiceNuovoUtente"  class="js-switch" value="si" <?php if($impostazioni["creaCartellaRadiceNuovoUtente"]=="si") echo"checked"; ?> />
                        <small class="text-muted d-block">Crea automaticamente una cartella radice quando viene creato un nuovo utente</small>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="titolo-del-sito">Prefisso cartella radice</label>
                        <input type="text" class="form-control" id="titolo-del-sito" name="prefissoCartellaRadice" value="<?php echo $impostazioni["prefissoCartellaRadice"] ?>" placeholder="Prefisso cartella radice">
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="titolo-del-sito">Nome cartella radice</label>
                        <select name="campoDaUsareNomeCartellaRadice" class="form-control">
                            <option value="random">Assegna un valore random</option>
                            <?php 
                                $risCampiTabella = $geecomDb->elencoColonneTabella("geec_utenti");
                                while($campo = $risCampiTabella->fetch_assoc()) {
                                    $selezionato = ($impostazioni["campoDaUsareNomeCartellaRadice"]==$campo["Field"]) ? "selected" : "";
                                    echo"<option value=\"{$campo["Field"]}\" $selezionato>{$campo["Field"]}</option>";
                                }
                            ?>
                        </select>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="select1" class="d-block">Crea sottocartelle</label>
                        <input type="checkbox" name="creaSottocartelleDaTemplate" class="js-switch" value="si" <?php if($impostazioni["creaSottocartelleDaTemplate"]=="si") echo"checked"; ?> />
                        <small class="text-muted d-block">Se selezionato la cartella radice verrà popolata con il contenuto del template scelto </small>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="titolo-del-sito">Template sottocartelle</label>
                        <select id="templateCartelle" name="templateCartelle" class="form-control">
                            <option value="0">Seleziona</option>
                            <?php 
                                $query       = "SELECT * FROM geecD_templateCartelle";
                                $risCartelle = $geecomDb->eseguiQueryLettura($query);
                                while($templateCartella = $risCartelle->fetch_assoc()) {
                                    $selezionato = ($templateCartella["id"]==$impostazioni["templateCartelle"]) ? "selected" : "";
                                    echo"<option value=\"{$templateCartella["id"]}\" $selezionato>{$templateCartella["nome"]}</option>";
                                }
                            ?>
                        </select>
                    </div>
                </div>
                
                <div class="w-100"></div>
                
                 <div class="col-md-4">
                    <div class="form-group">
                        <label for="select1" class="d-block">Usa unica cartella radice per gli utenti super admin</label>
                        <input type="checkbox" name="usaUnicaCartellaRadiceSuperAdmin" class="js-switch" value="si" <?php if($impostazioni["usaUnicaCartellaRadiceSuperAdmin"]=="si") echo"checked"; ?> />
                        <small class="text-muted d-block">Se selezionato gli utenti supera admin avranno come cartella radice la cartella radice di Geecom Doc</small>
                    </div>
                </div>
            </div>    

            <button type="button" class="btn btn-primary float-right" onclick="document.formAggiornamentoImpostazioniTemplateCartelle.submit()"><i class="fas fa-check"></i> Salva tutto</button>

        </form>        
    </div>
    <div id="elencoTemplate" class="tab-pane fade show <?= (isset($_GET["status"]) && $_GET["status"]==121) ? "active" : "" ?> px-0 shadow-none" role="tabpanel">
        <div class="row">
            <div class="col-12 gerarchia-menu">
                <a href="creaTemplateCartelle.php" class="btn btn-sm btn-primary mb-3" >
                    Crea nuovo<i class="fas fa-plus ml-2"></i>
                </a>
                
                <div class="d-flex justify-content-between mb-3">
                    <?php
                        $ricerca->stampaSelectNumeroElementi($cerca);
                        $ricerca->stampaFormRicerca($cerca);
                    ?>
                </div>
                <div class="table-responsive" id="divElencoUtenzeApi">
                    <?php
                        if(isset($_GET["pag"])) {
                            $ris = $ricerca->eseguiRicerca($_GET["pag"],"OR");
                        }
                        else {
                            $ris = $ricerca->eseguiRicerca(1,"OR");
                        }

                        $colonne = array("ID","Nome","Descrizione","Cartella collegata","");
                        $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                        $tabella->setTipo("normale");
                        while($templateCartelle = $ris->fetch_assoc()) {
                            $nomeEscape = filter_var($templateCartelle["nome"],FILTER_SANITIZE_ADD_SLASHES);
                            $datiCartellaCollegata = $geecomDb->leggiSingolaRiga("geecD_cartelle",$templateCartelle["cartellaCollegata"]);
                                    
                            $azioni = array("modifica"=>"creaTemplateCartelle.php?id={$templateCartelle["id"]}","elimina"=>"apriPopupEliminaUtenzaApi({$templateCartelle["id"]},'{$nomeEscape}')");
                            $tabella->aggiungiNuovaRiga(array($templateCartelle["id"],"<a href=\"creaTemplateCartelle.php?id={$templateCartelle["id"]}\"><b>{$templateCartelle["nome"]}</b></a>",$templateCartelle["descrizione"],$datiCartellaCollegata["nome"]), $azioni);
                        }
                        $tabella->stampa("utenzaApi",0);
                        $ricerca->stampaPaginazione(true,"impsotazioni.php");
                    ?>
                </div>
            </div>
        </div>
    </div>
    <div id="operazioniMassive" class="tab-pane fade show px-0 pb-0 shadow-none" role="tabpanel">
        <form name="formEseguiOperazioneMassive" action="../controller/controllerImpostazioni.php" method="post">
            <input type="text" class="d-none" name="operazione" value="eseguiOperazioniMassive">
            
            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-4">
                <div class="form-group col">
                    <label>Template</label>
                    <select id="template" class="form-control">
                       <option value="0">Seleziona</option>
                       <?php 
                           $query       = "SELECT * FROM geecD_templateCartelle";
                           $risTemplate = $geecomDb->eseguiQueryLettura($query);
                           while($template = $risTemplate->fetch_assoc()) {
                               echo"<option value=\"{$template["id"]}\">{$template["nome"]}</option>";
                           }
                       ?>
                   </select>
                </div>

                <div class="form-group col">
                    <label>Attribuisci a</label>
                    <select id="cartellaRadice" class="form-control">
                       <option value="0">Seleziona</option>
                       <option value="Utenti selezionati">Utenti selezionati</option>
                       <option value="Gruppi di utenti">Gruppi di utenti</option>
                   </select>
                </div>

                <div class="form-group col">
                    <label>Gruppi</label>
                    <select id="cartellaRadice" class="form-control">
                       <option value="0">Seleziona</option>
                       <?php 
                           $query     = "SELECT * FROM geec_gruppi";
                           $risGruppi = $geecomDb->eseguiQueryLettura($query);
                           while($gruppo = $risGruppi->fetch_assoc()) {
                               echo"<option value=\"{$gruppo["id"]}\">{$gruppo["nome"]}</option>";
                           }
                       ?>
                   </select>
                </div>

                <div class="col">
                    <div class="mb-2">
                        <input type="checkbox" name="creaCartellaRadiceNuovoUtente"  class="js-switch" value="si" <?php if($impostazioni["creaCartellaRadiceNuovoUtente"]=="si") echo"checked"; ?> />
                        <label for="select1" class="ml-2">Sovrascrivi file e cartelle</label>
                    </div>

                    <div class="">
                        <input type="checkbox" name="creaCartellaRadiceNuovoUtente"  class="js-switch" value="si" <?php if($impostazioni["creaCartellaRadiceNuovoUtente"]=="si") echo"checked"; ?> />                    
                        <label for="select1" class="ml-2">Elimina contenuto precedente</label>
                    </div>
                </div>
            </div>
        </form>
        <button type="button" class="btn btn-primary float-right" onclick="document.formEseguiOperazioneMassive.submit()"><i class="fas fa-check"></i> Esegui</button>
    </div>
</div>